unit fROR_VUSelector;
{
================================================================================
*
*       Package:        ROR - Clinical Case Registries
*       Date Created:   $Revision: 7 $  $Modtime: 3/06/07 2:23p $
*       Site:           Hines OIFO
*       Developers:
*                       Andrey Andriyevskiy
*
*       Description:    Vista User Selection window
*
*       Notes:
*
================================================================================
*       $Archive: /CCR v1.5/Current/fROR_VUSelector.pas $
*
* $History: fROR_VUSelector.pas $
 * 
 * *****************  Version 7  *****************
 * User: Vhaishgavris Date: 3/08/07    Time: 1:47p
 * Updated in $/CCR v1.5/Current
 * 
 * *****************  Version 6  *****************
 * User: Vhaishgavris Date: 1/10/05    Time: 3:48p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 5  *****************
 * User: Vhaishgavris Date: 10/14/04   Time: 3:50p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 4  *****************
 * User: Vhaishandria Date: 2/02/04    Time: 5:03p
 * Updated in $/ICR v3.0/Current
 * 
 * *****************  Version 3  *****************
 * User: Vhaishgavris Date: 1/16/04    Time: 12:54p
 * Updated in $/ICR v3.0/Current
 * 
 * *****************  Version 2  *****************
 * User: Vhaishandria Date: 11/24/03   Time: 5:36p
 * Updated in $/ICR v3.0/Current
 * 
 * *****************  Version 1  *****************
 * User: Vhaishgavris Date: 9/11/03    Time: 5:03p
 * Created in $/ICR v3.0/Current
 * 
 * *****************  Version 2  *****************
 * User: Vhaishandria Date: 8/01/03    Time: 9:48a
 * Updated in $/ICR v3.0/Current
 * Build 63
 * 
 * *****************  Version 1  *****************
 * User: Vhaishandria Date: 7/31/03    Time: 10:52a
 * Created in $/ICR v3.0/Current
*
================================================================================
}

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ComCtrls;

type
  TdlgVUSelector = class(TForm)
    Panel1: TPanel;
    OKBtn: TButton;
    CancelBtn: TButton;
    Panel2: TPanel;
    edtTarget: TEdit;
    lvVUsers: TListView;
    chkbUpper: TCheckBox;
    Button1: TButton;
    chkbClear: TCheckBox;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure lvVUsersDblClick(Sender: TObject);
    procedure lvVUsersChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure edtTargetKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure lvVUsersKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  dlgVUSelector: TdlgVUSelector;

implementation
uses
  uROR_Utilities, uROR_CommonUtils, uROR_Common, Dialogs,
  uROR_Broker;

{$R *.DFM}

procedure TdlgVUSelector.Button1Click(Sender: TObject);
var
  s: String;
begin
  if Trim(edtTarget.Text) = '' then
    begin
      MessageDlg508('Physician Selection',
        'Please, narrow the search criteria.',mtInformation, [mbOK], 0);
      exit;
    end;
  Screen.Cursor := crHourGlass;
  s := edtTarget.Text;
  if chkbUpper.Checked then s := Uppercase(s);
  if Broker.CallProc(rpcListVistaUsers, [s,'PD']) then
    begin
      UpdateListView(Broker.Results,lvVUsers,1,[2,3,4,7], chkbClear.Checked);
      try
        ActiveControl := lvVUsers;
      except
      end;
    end;
  Screen.Cursor := crDefault;
end;

procedure TdlgVUSelector.lvVUsersDblClick(Sender: TObject);
begin
  ModalResult := mrOK;
end;

procedure TdlgVUSelector.lvVUsersChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
  OKBtn.Enabled := lvVUsers.Selected <> nil;
end;

procedure TdlgVUSelector.edtTargetKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_Return then Button1Click(nil);
end;

procedure TdlgVUSelector.lvVUsersKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key = VK_Return then
    ModalResult := mrOK;
end;

end.
